/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.discount;

import com.android.invoice.domain.model.AInvoiceDtlDto;
import com.android.invoice.domain.model.AInvoiceDto;
import com.android.invoice.domain.use_case.discount.CalcDiscount;
import com.android.invoice.domain.use_case.discount.DiscountCommissionTools;
import com.android.product.domain.model.ProductDto;
import com.customer.domain.use_case.GetCustomerList;
import com.dto.CustomerDto;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncJdbc;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class CalcCommission {
    private final DbConnection dbConnection;
    private final GetCustomerList getCustomerList;
    private DiscountCommissionTools commissionTools;
    private AInvoiceDto dto;
    private SettingLoader settingLoader;
    private TncJdbc jdbc;
    private ProductDto prDto;
    private double commissionTotalSum;
    private double commissionSum;
    private double perRowTieredCommission;
    private double tieredCommissionSum;
    private double sumPerRowDiscountPercent;
    private int discountState = 0;
    private String userMidManCode;

    private void init() {
        LoginDto login = SecurityConstants.loadToken();
        this.settingLoader = new SettingLoader(this.dbConnection, login);
        this.jdbc = this.dbConnection.getJdbcTemplate(login);
        this.discountState = this.settingLoader.getDiscountMode();
        this.commissionTools = new DiscountCommissionTools(this.dbConnection, this.jdbc, this.dto);
    }

    public double invoke(AInvoiceDto dto, double sumPerRowDiscountPercent) throws TncException {
        this.dto = dto;
        this.init();
        this.sumPerRowDiscountPercent = sumPerRowDiscountPercent;
        this.userMidManCode = this.settingLoader.getMidManId();
        double totalPriceForInvoice = 0.0;
        double invoiceCommission = 0.0;
        for (AInvoiceDtlDto dtl : dto.getDtlDto()) {
            if (dtl.getProductCode().isEmpty() || dtl.getProductCode().equals("000000") || ConvertStr.isNullOrEmpty((String)this.userMidManCode) || this.userMidManCode.equals("0")) continue;
            this.fetchProductData(dtl.getProductCode());
            dtl.setPerRowDiscountAmount(Double.valueOf(this.calcPerRowCommission(dtl)));
            if (this.unitEnabled()) {
                totalPriceForInvoice += ConvertStr.nullAndMultiplySafeDouble((Double)dtl.getCoefficient()) * dtl.getAmount() * dtl.getPrice();
                continue;
            }
            totalPriceForInvoice += dtl.getAmount() * dtl.getPrice();
        }
        if (!ConvertStr.isNullOrEmpty((String)this.userMidManCode) && !this.userMidManCode.equals("0")) {
            invoiceCommission = this.calcMidManCommission(totalPriceForInvoice);
        }
        this.commissionTotalSum = this.commissionSum + invoiceCommission + this.perRowTieredCommission + this.tieredCommissionSum;
        return this.commissionTotalSum;
    }

    private boolean unitEnabled() {
        return this.settingLoader.getDollarUnit() == 1 && this.settingLoader.getSecondUnit();
    }

    private void fetchProductData(String productCode) {
        this.prDto = this.commissionTools.getProduct(productCode, this.jdbc);
    }

    private double calcPerRowCommission(AInvoiceDtlDto dtl) {
        double result = 0.0;
        this.perRowTieredCommission = 0.0;
        double amount = dtl.getAmount();
        if (this.unitEnabled()) {
            amount *= ConvertStr.nullAndMultiplySafeDouble((Double)dtl.getCoefficient());
        }
        if (this.settingLoader.tieredCommissionEnabled()) {
            this.perRowTieredCommission = this.calcTieredCommission(dtl);
            result = this.calcPerRowBasedOnCommissionAfterDiscount(dtl, amount);
            this.commissionSum += result;
        } else if (this.settingLoader.perRowCommissionEnabled()) {
            result = this.calcPerRowBasedOnCommissionAfterDiscount(dtl, amount);
            this.commissionSum += result;
            this.sumPerRowDiscountPercent += result;
        }
        return result += this.perRowTieredCommission;
    }

    private double calcPerRowBasedOnCommissionAfterDiscount(AInvoiceDtlDto dtl, double amount) {
        double result = this.settingLoader.calcCommissionAfterDiscountEnabled() ? (amount * dtl.getPrice() - this.perRowDiscountForCommission(amount * dtl.getPrice())) * this.calcPerRowCommissionPercent(dtl.getProductCode()) / 100.0 : amount * dtl.getPrice() * this.calcPerRowCommissionPercent(dtl.getProductCode()) / 100.0;
        return result;
    }

    private double perRowDiscountForCommission(double totalDtlPrice) {
        if (this.discountState != 2) {
            return 0.0;
        }
        double result = !this.settingLoader.useRialDiscountPercent() && !this.settingLoader.isUsePerRowDiscountPrice() ? totalDtlPrice * this.prDto.getDiscountPercent() / 100.0 : this.prDto.getDiscountPrice();
        return result;
    }

    private double calcTieredCommission(AInvoiceDtlDto dtl) {
        double dtlPrice = dtl.getAmount() * dtl.getPrice();
        double sumPerRowCommission = 0.0;
        if (ConvertStr.isNullOrEmpty((String)this.userMidManCode)) {
            return 0.0;
        }
        double fCommission = this.settingLoader.perRowCommissionEnabled() && (this.settingLoader.mGroupCommissionEnabled() || this.settingLoader.sGroupCommissionEnabled() || this.settingLoader.articleCommissionEnabled()) && !this.settingLoader.midManCommissionEnabled() ? dtlPrice * this.calcPerRowCommissionPercent(dtl.getProductCode()) / 100.0 : (this.settingLoader.midManCommissionEnabled() ? dtlPrice * this.calcPerRowCommissionPercent(dtl.getProductCode()) / 100.0 : this.commissionTotalSum);
        this.tieredCommissionSum = 0.0;
        double result = this.settingLoader.tieredCommissionMode() == 0 ? this.makeDataAndCalcTieredCommission(1, dtl, 0.0) : this.makeDataAndCalcTieredCommission(1, dtl, fCommission);
        this.tieredCommissionSum = this.makeDataAndCalcTieredCommission(0, dtl, sumPerRowCommission += result);
        return result;
    }

    private double calcPerRowCommissionPercent(String productCode) {
        double result = 0.0;
        if (this.settingLoader.mGroupCommissionEnabled()) {
            if (this.settingLoader.differentCommissionForMidManPerMGroup()) {
                Double commPercent = (Double)this.jdbc.queryForObject("SELECT isNull((SELECT IsNull(DarsadPorsantV, 0) \n FROM PorsantVaseteh \n WHERE A_Code = '" + productCode.substring(0, 2) + "' \n  AND C_Code = '" + this.userMidManCode + "'), 0)", Double.class);
                result = ConvertStr.nullSafeDouble((Double)commPercent);
            } else {
                Double commPercent = (Double)this.jdbc.queryForObject("SELECT IsNull(DarsadPorsant, 0) \n FROM M_group \n WHERE M_GroupCode = '" + productCode.substring(0, 2) + "'", Double.class);
                result = ConvertStr.nullSafeDouble((Double)commPercent);
            }
        } else if (this.settingLoader.sGroupCommissionEnabled()) {
            if (this.settingLoader.differentCommissionForMidManPerSGroup()) {
                Double commPercent = (Double)this.jdbc.queryForObject("SELECT isNull((SELECT IsNull(DarsadPorsantV, 0) \n FROM PorsantVaseteh \n WHERE A_Code = '" + productCode.substring(0, 4) + "' \n  AND C_Code = '" + this.userMidManCode + "'), 0)", Double.class);
                result = ConvertStr.nullSafeDouble((Double)commPercent);
            } else {
                Double commPercent = (Double)this.jdbc.queryForObject("SELECT IsNull(DarsadPorsant, 0) \n FROM S_group \n WHERE M_GroupCode = '" + productCode.substring(0, 2) + "' AND S_GroupCode = '" + productCode.substring(2, 4) + "'", Double.class);
                result = ConvertStr.nullSafeDouble((Double)commPercent);
            }
        } else if (this.settingLoader.articleCommissionEnabled()) {
            if (this.settingLoader.differentCommissionForMidManPerArticle()) {
                Double commPercent = (Double)this.jdbc.queryForObject("SELECT isNull((SELECT IsNull(DarsadPorsantV, 0) \n FROM PorsantVaseteh \n WHERE A_Code = '" + productCode + "' \n  AND C_Code = '" + this.userMidManCode + "'), 0)", Double.class);
                result = ConvertStr.nullSafeDouble((Double)commPercent);
            } else {
                Double commPercent = (Double)this.jdbc.queryForObject("SELECT ISNULL(Darsadporsant, 0) \n From Article \n WHERE A_Code = '" + productCode + "'", Double.class);
                result = ConvertStr.nullSafeDouble((Double)commPercent);
            }
        }
        return result;
    }

    private double makeDataAndCalcTieredCommission(int actionType, AInvoiceDtlDto dtl, double invoiceCommission) {
        if (!this.settingLoader.tieredCommissionEnabled()) {
            return 0.0;
        }
        CalcDiscount.TieredDiscountOrCommissionData tieredDiscountData = new CalcDiscount.TieredDiscountOrCommissionData(CalcDiscount.RequestType.COMMISSION, invoiceCommission, actionType, dtl.getProductCode(), dtl.getAmount(), dtl.getPrice(), dtl.getThirdAmount().doubleValue(), dtl.getSecondAmount().doubleValue(), dtl.getUnitCode(), dtl.getCoefficient().doubleValue(), 0.0);
        return this.commissionTools.calcTieredDiscountCommission(tieredDiscountData);
    }

    private double calcMidManCommission(double totalPriceForInvoice) {
        CustomerDto midMan = this.commissionTools.fetchCustomer(this.userMidManCode, this.getCustomerList);
        double result = 0.0;
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT IsNull(Vaseteh_Porsant, 0) midManComm \n FROM CustomerVaseteh \n WHERE C_Code = '" + this.dto.getPartyCode() + "' And Vaseteh_Code = '" + this.userMidManCode + "'");
        double commissionPercent = rs.next() ? rs.getDouble("midManComm") : midMan.getVasetehporsant().doubleValue();
        AtomicBoolean perRowCommEnabled = new AtomicBoolean(false);
        AtomicBoolean commDisabled = new AtomicBoolean(false);
        AtomicBoolean midManCommEnabled = new AtomicBoolean(false);
        AtomicBoolean discountPercentEnabled = new AtomicBoolean(false);
        AtomicBoolean commAfterDiscount = new AtomicBoolean(false);
        this.settingLoader.getMapMultiple(sqlRowSet -> sqlRowSet.getBoolean("Boolean"), map -> {
            perRowCommEnabled.set(map.getOrDefault("PorsantSatri", false));
            commDisabled.set(map.getOrDefault("NoPorsant", false));
            midManCommEnabled.set(map.getOrDefault("Porsant_vaset", false));
            discountPercentEnabled.set(map.getOrDefault("DarsadTakhfifR", false));
            commAfterDiscount.set(map.getOrDefault("PorsantAfterTakhfif", false));
        }, "[Boolean]", "0", new String[]{"PorsantSatri", "NoPorsant", "Porsant_vaset", "DarsadTakhfifR", "PorsantAfterTakhfif,ChBoxVasetehSatri"});
        if (!perRowCommEnabled.get() || commDisabled.get() || midManCommEnabled.get()) {
            boolean usedDiscountPercent = this.discountState == 2;
            result = usedDiscountPercent && discountPercentEnabled.get() && commAfterDiscount.get() ? (totalPriceForInvoice - this.sumPerRowDiscountPercent) * commissionPercent / 100.0 : totalPriceForInvoice * commissionPercent / 100.0;
        }
        return result;
    }

    public CalcCommission(DbConnection dbConnection, GetCustomerList getCustomerList) {
        this.dbConnection = dbConnection;
        this.getCustomerList = getCustomerList;
    }
}

